% Author: Layla S. Mayboudi
% 2021-05-27
% This code presents the inputted thermal conductivity along the x-,
% y-, and z-coordinates in the form of a symmetrical array.


function therm3 = ThermalCond3 ()
k=zeros(1,3);
for i=1:3
    %The component vector ID's: 1, 2, or 3 for Kx, Ky, and kz
    switch i
        case 1
            k(i) = input ('Thermal conductivity in the x direction (W/mK)= \n'); %W/mK            
            name_k{i} = 'Thermal conductivity in the x direction (W/mK)'; 
            display(blanks(1))
            fprintf('%s = %d \n',name_k{i},k(i));            
        case 2
            k(i) = input ('Thermal conductivity in the y direction (W/mK)= \n'); %W/mK            
            name_k{i} = 'Thermal conductivity in the y direction (W/mK)';
            display(blanks(1))
            fprintf('%s = %d \n',name_k{i},k(i));
        otherwise
            k(i) = input ('Thermal conductivity in the z direction (W/mK)= \n'); %W/mK            
            name_k{i} = 'Thermal conductivity in the z direction (W/mK)';
            display(blanks(1))
            fprintf('%s = %d \n',name_k{i},k(i));            
    end
end
thermal_conductivity = k     